


/******************************************************************************************
 *                                                                                        *
 * Ex1.     :   Read BCD Code(4bit) From Touch PAD Key 4x4 Out To RS232                   *
 *                        (Format:Press Single Key only)  	                              *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU     : ATMEL AVR-MEGA128                                                     *
 *       	      : X-TAL : 16 MHz                                                        *
 *                                                                                        *
 * Editor         : AVR Studio 4.15 Build 623                                             *
 * Compiler       : WinAVR-20081205                                                       *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                  *
 * Last Update    : 09/September/2014                                                     *
 *																				          *
 * Port Interface :  -- MCU-AVR-Mega 128--	  	  	       -- Key Touch PAD 4x4 --        *
 *                                                                                        *
 *                   PA0(Input)       Connect                 BCD Colum 1                 * 
 *                   PA1(Input)       Connect                 BCD Colum 2                 *
 *                   PA2(Input)       Connect			      BCD Colum 4                 *
 *                   PA3(Input)		  Connect				  BCD Colum 8                 *
 *					 PA4(Input)	      Connect                 T#/R Ststus 1Key 	          *
 *                   PA5(Input)       No use                  SHIF# Statu 2Key            *
 *                                                                                        *
 *																						  *
 *       Uart0    :  PE0 = RXDO 	  Connect                 Tx Comport PC               *  
 *                   PE1 = TXD0		  Connect                 Rx Comport PC               * 												  *
 *                   Baud Rate = 9600 at Clock 16 Mhz                                     *
 *                                                                                        *
 *    LED DISPLAY : PC[0..7]	           Connect	              LED Common Anode 		  *
 *                                                                						  *  
 *                                                                             5V		  *
 *                                                                             -+- 		  *
 *                                                              560      \\     |  		  *
 *                                                       PC0 --/\/\/\---|<|-----+		  *
 *												 	             	 	 .	    |		  *
 *                                                              560      . \\   | 		  *
 *                                                       PC7 --/\/\/\---|<|-----+  		  *
 *																						  *
 *                                                                                        *
 *   Operation    : When Touch Key will Show Key Code on Heperterminal and LED PC[0..7]   *
 *																						  *
 ******************************************************************************************/


#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)

unsigned int Check_TR(void)     ;
unsigned int RD_KeyCode(void)   ;


 
/***************************************************************
 **                 Function use For Printf(UART0)            **
 ***************************************************************/


//--------------------- Prototype function ---------------------

static int uart_putchar(char c,FILE *stream) ;
static FILE uart_str = FDEV_SETUP_STREAM(uart_putchar,NULL,_FDEV_SETUP_WRITE);
void Init_Serial(unsigned int baudrate);


//----------------------- UART0 Putchar -------------------------

static int uart_putchar(char c,FILE *stream)
 {
   if(c=='\a')
     {
	  fputs("*ring*\n",stderr) ;
	  return 0 ;
     }
   
   if(c=='\n')
     uart_putchar('\r',stream) ;

   loop_until_bit_is_set(UCSR0A,UDRE);
   UDR0 = c ;

   return 0 ;
 }

//------------------- Initial UART0 -----------------------

static void UART0_Init(void)
 {

   UCSR0B = 0x00      ;     //disable while setting baud rate
   UBRR0H = 0         ;
   UBRR0L = 104       ;     //Set Baud Rate 9600 : BURR= Fosc/[16x(9600)]-1
  
   UCSR0B = 0x98      ;     //Uart0 Control Enable Reciver and transmitter
   UCSR0C = 0x06      ;     //Set Frame format : 8data,NoneParity,1stop bit

   
   stdout = &uart_str ;     //Set address uart_str to stdout

 }



//*************************** Main *************************

 int main (void) 
  { 
   
   unsigned int key=0;                               

   //---------------Initial Port I/O ----------------

   DDRA  = 0x00     ;        //Set PA0..PA7 = Input for Read Key Code BCD,Status key and Shift Key      
   DDRC  = 0xFF     ;        //Set PC0..PC7 = Output for Display Key Code
    
   PORTA = 0xFF     ;        //Set Default data  PortA Full-UP       
   PORTC = 0xFF     ;        //Set Default data PortC=  LED OFF
   
  

   UART0_Init()     ;        //Initial Uart0


    
  printf("*************************************************************************\r\n");    
  printf("**          Ex1.TEST READ KEY CODE BCD Touch PAD4x4                    **\r\n");        
  printf("*************************************************************************\r\n"); 
  
 
   while(1)
    {
   
	   if(!Check_TR())                                 //Step1: Check  pressed key (Check_TR()=0:press,1:release) 
	    {
		  key = RD_KeyCode()                       ;   //Step2: Read Key Code

	     //---------- Step3:Program Respond press key for user ------------
       
	      PORTC = ~key					           ;   //Out Hex data key Code to LED PC[0..7]
	      printf("Key_Code BCD = 0x0%X",key)       ;   //Print Key Code Out RS232
	      printf("\n\r")                           ;

		  while(!Check_TR()){;}                        //Wait Release Key (=1 exit loop)
		
	    } 		   
   	 
    }	//while


  }  //End




 //********************** Sub Program *************************


//--------- Check Touch /Release Key -----------

unsigned int Check_TR(void)    
 {
   unsigned int tr   ;
        
       tr  = PINA                ;   //Read Status Key
	   tr  = tr & 0x10           ;   //Mark bit PA (Statust Press or Release)
	
	 if(tr != 0x10)           	     //Check Statue Key
	   return (0)                ;	 //Touch Key Return 0 (PA4=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(PA4=1)
 }


//---------- Read BCD Key Code -----------------

 unsigned int RD_KeyCode(void) 
  {
	 unsigned int KeyCode                  ;
   
     KeyCode      = PINA                   ;   //Read Key Code
	 KeyCode      = KeyCode & 0x0F         ;   //Mark bit PA0-PA3(Key Code 4 bit)
	 return (KeyCode)                      ;
  }










